/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.base.logging.Logger;
import filenet.ws.api.IWSTypeEntry;
import filenet.ws.api.WSAttribute;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSElementDecl;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.IntHolder;
import org.apache.axis.Constants;
import org.apache.axis.wsdl.symbolTable.CollectionType;
import org.apache.axis.wsdl.symbolTable.ContainedAttribute;
import org.apache.axis.wsdl.symbolTable.DefinedType;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.symbolTable.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSType
implements IWSTypeEntry {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    private static String m_className = "WSType";
    private WSDefinition m_definition = null;
    private Type m_type = null;
    private WSType m_simpleBaseType = null;
    private IWSTypeEntry[] m_references = null;
    private WSType m_extensionBaseType = null;
    private WSElementDecl[] m_elementDecls = null;
    private Vector m_elementDeclWithChoiceGroups = null;
    private WSAttribute[] m_attributes = null;
    private String m_baseName = null;
    private QName m_simpleTypeBaseQName = null;
    private QName m_restrictionBaseQName = null;
    private Node m_restrictionBaseNode = null;
    private Vector m_enumBaseAndValues = null;
    private String m_maxOccurs = "1";
    private String m_minOccurs = "1";
    private boolean m_bEnum = false;
    private boolean m_bChoice = false;
    private String m_typeName = null;
    private boolean m_bInitialized = false;

    public static String _get_FILE_DATE() {
        return "$Date:   15 Oct 2008 18:53:58  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.32  $";
    }

    public void releaseReferences() {
        block15: {
            try {
                int i;
                Object type = null;
                Object element = null;
                Object elementDecl = null;
                Object typeEntry = null;
                Object attribute = null;
                this.m_definition = null;
                this.m_type = null;
                if (this.m_references != null) {
                    for (i = 0; i < this.m_references.length; ++i) {
                        if (this.m_references[i] != null) {
                            this.m_references[i].releaseReferences();
                        }
                        this.m_references[i] = null;
                    }
                    this.m_references = null;
                }
                if (this.m_simpleBaseType != null) {
                    this.m_simpleBaseType.releaseReferences();
                    this.m_simpleBaseType = null;
                }
                if (this.m_extensionBaseType != null) {
                    this.m_extensionBaseType.releaseReferences();
                    this.m_extensionBaseType = null;
                }
                if (this.m_elementDecls != null) {
                    for (i = 0; i < this.m_elementDecls.length; ++i) {
                        if (this.m_elementDecls[i] == null) continue;
                        this.m_elementDecls[i].releaseReferences();
                    }
                    this.m_elementDecls = null;
                }
                if (this.m_elementDeclWithChoiceGroups != null) {
                    WSElementDecl[] elementDecls = null;
                    Object obj = null;
                    Enumeration entries = this.m_elementDeclWithChoiceGroups.elements();
                    while (entries.hasMoreElements()) {
                        obj = entries.nextElement();
                        if (obj == null || !(obj instanceof WSElementDecl[])) continue;
                        elementDecls = obj;
                        for (int j = 0; j < elementDecls.length; ++j) {
                            if (elementDecls[j] == null) continue;
                            elementDecls[j].releaseReferences();
                        }
                    }
                    this.m_elementDeclWithChoiceGroups.removeAllElements();
                    this.m_elementDeclWithChoiceGroups = null;
                }
                if (this.m_attributes != null) {
                    for (int i2 = 0; i2 < this.m_attributes.length; ++i2) {
                        if (this.m_attributes[i2] == null) continue;
                        this.m_attributes[i2].releaseReferences();
                        this.m_attributes[i2] = null;
                    }
                    this.m_attributes = null;
                }
                if (this.m_enumBaseAndValues != null) {
                    this.m_enumBaseAndValues.removeAllElements();
                    this.m_enumBaseAndValues = null;
                }
                this.m_baseName = null;
                this.m_simpleTypeBaseQName = null;
                this.m_restrictionBaseQName = null;
                this.m_restrictionBaseNode = null;
                this.m_maxOccurs = null;
                this.m_minOccurs = null;
                this.m_typeName = null;
                type = null;
                element = null;
                elementDecl = null;
                attribute = null;
                typeEntry = null;
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block15;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSType(WSDefinition definition, Type type) {
        this.m_definition = definition;
        this.m_type = type;
    }

    private void init() {
        String m_method = "init";
        if (this.m_type != null && !this.m_bInitialized) {
            this.m_bInitialized = true;
            TypeEntry refTypeEntry = null;
            Object wsType = null;
            this.m_baseName = this.getBaseName();
            this.m_typeName = this.m_type.getQName().toString();
            Node node = this.m_type.getNode();
            String occurs = null;
            if (this.isCollection()) {
                occurs = Utils.getAttribute((Node)node, (String)"maxOccurs");
                this.m_maxOccurs = occurs != null && occurs.length() > 0 ? occurs : "unbounded";
            }
            this.m_minOccurs = (occurs = Utils.getAttribute((Node)node, (String)"minOccurs")) != null && occurs.length() > 0 ? occurs : "1";
            refTypeEntry = this.m_type.getRefType();
            Vector<IWSTypeEntry> references = new Vector<IWSTypeEntry>();
            if (refTypeEntry != null) {
                references.add(this.m_definition.getTypeEntry(refTypeEntry));
            }
            while (refTypeEntry != null) {
                if ((refTypeEntry = refTypeEntry.getRefType()) == null) continue;
                references.add(this.m_definition.getTypeEntry(refTypeEntry));
            }
            if (references != null && references.size() > 0) {
                this.m_references = new IWSTypeEntry[references.size()];
                references.toArray(this.m_references);
                references.removeAllElements();
            }
            Vector elementDeclVector = new Vector();
            Vector attributes = new Vector();
            TypeEntry typeEntry = null;
            if (this.m_type instanceof CollectionType) {
                typeEntry = this.m_type.getRefType();
            } else if (this.m_type instanceof DefinedType) {
                typeEntry = this.m_type;
            }
            if (typeEntry != null) {
                Node n;
                TypeEntry complexBaseType = null;
                Vector v = null;
                Vector<TypeEntry> typeEntries = new Vector<TypeEntry>();
                while (typeEntry != null) {
                    typeEntries.add(typeEntry);
                    if (!SchemaUtils.isSimpleTypeOrSimpleContent((Node)typeEntry.getNode()) && (v = SchemaUtils.getContainedElementDeclarations((Node)typeEntry.getNode(), (SymbolTable)this.m_definition.m_symTable)) != null && v.size() > 0) {
                        v.addAll(elementDeclVector);
                        elementDeclVector = v;
                    }
                    this.m_simpleTypeBaseQName = SchemaUtils.getSimpleTypeBase((Node)typeEntry.getNode());
                    if (this.m_simpleTypeBaseQName != null) {
                        this.m_simpleBaseType = this.m_definition.getType(this.m_simpleTypeBaseQName);
                        break;
                    }
                    if (!(typeEntry instanceof DefinedType)) break;
                    v = SchemaUtils.getContainedAttributeTypes((Node)typeEntry.getNode(), (SymbolTable)this.m_definition.m_symTable);
                    if (v != null && v.size() > 0) {
                        attributes.addAll(0, v);
                    }
                    if ((complexBaseType = SchemaUtils.getComplexElementExtensionBase((Node)typeEntry.getNode(), (SymbolTable)this.m_definition.m_symTable)) == null) break;
                    if (!SchemaUtils.isSimpleTypeOrSimpleContent((Node)complexBaseType.getNode())) {
                        this.m_extensionBaseType = this.m_definition.getType(complexBaseType);
                    }
                    if (complexBaseType != null && typeEntries.contains(complexBaseType)) break;
                    typeEntry = complexBaseType;
                }
                v = this.getEnumerationBaseAndValues(typeEntry.getNode(), this.m_definition.m_symTable);
                if (v != null && v.size() > 0) {
                    this.m_enumBaseAndValues = v;
                    this.m_bEnum = true;
                }
                QName qname = SchemaUtils.getAttributeAnonQName((Node)typeEntry.getNode());
                qname = SchemaUtils.getElementAnonQName((Node)typeEntry.getNode());
                if (this.m_extensionBaseType != null && this.m_extensionBaseType.getType() != null) {
                    if (this.m_extensionBaseType.isBaseType()) {
                        this.m_simpleBaseType = this.m_extensionBaseType;
                    } else {
                        typeEntry = this.m_extensionBaseType.getType();
                        Vector extension = null;
                        if (!SchemaUtils.isSimpleTypeOrSimpleContent((Node)typeEntry.getNode())) {
                            extension = SchemaUtils.getContainedElementDeclarations((Node)typeEntry.getNode(), (SymbolTable)this.m_definition.m_symTable);
                        }
                        if (v != null && extension != null) {
                            extension.addAll(v);
                        }
                    }
                }
                if (elementDeclVector != null && elementDeclVector.size() > 0) {
                    this.m_elementDecls = new WSElementDecl[elementDeclVector.size()];
                    this.m_elementDeclWithChoiceGroups = new Vector();
                    for (int i = 0; i < elementDeclVector.size(); ++i) {
                        Object obj = elementDeclVector.get(i);
                        if (obj == null || !(obj instanceof ElementDecl)) continue;
                        this.m_elementDecls[i] = this.m_definition.getElementDecl((ElementDecl)obj, this.m_type);
                        this.m_elementDeclWithChoiceGroups.add(this.m_elementDecls[i]);
                    }
                    this.handleChoices(typeEntry.getNode(), this.m_elementDeclWithChoiceGroups);
                }
                if ((v = attributes) != null && v.size() > 0) {
                    Object obj = null;
                    ContainedAttribute attrib = null;
                    Vector<WSAttribute> attribs = new Vector<WSAttribute>();
                    for (int i = 0; i < v.size(); ++i) {
                        obj = v.get(i);
                        if (obj == null || !(obj instanceof ContainedAttribute)) continue;
                        attrib = obj;
                        attribs.add(new WSAttribute(this.m_definition, attrib));
                    }
                    if (attribs != null && attribs.size() > 0) {
                        this.m_attributes = new WSAttribute[attribs.size()];
                        attribs.toArray(this.m_attributes);
                        attribs.removeAllElements();
                    }
                }
                if ((n = SchemaUtils.getRestrictionOrExtensionNode((Node)typeEntry.getNode())) != null) {
                    if (n.getLocalName() == "restriction") {
                        this.m_restrictionBaseQName = Utils.getTypeQName((Node)n, (BooleanHolder)new BooleanHolder(), (boolean)false);
                        if (this.m_restrictionBaseQName != null) {
                            this.m_restrictionBaseNode = n;
                        }
                    }
                    IntHolder intHolder = new IntHolder();
                    qname = SchemaUtils.getAttributeAnonQName((Node)n);
                    TypeEntry t = SchemaUtils.getComplexElementExtensionBase((Node)n, (SymbolTable)this.m_definition.m_symTable);
                    v = SchemaUtils.getContainedAttributeTypes((Node)n, (SymbolTable)this.m_definition.m_symTable);
                    v = SchemaUtils.getContainedElementDeclarations((Node)n, (SymbolTable)this.m_definition.m_symTable);
                    qname = SchemaUtils.getElementAnonQName((Node)n);
                    Node nd = SchemaUtils.getRestrictionOrExtensionNode((Node)n);
                    qname = SchemaUtils.getSimpleTypeBase((Node)n);
                    boolean b = SchemaUtils.isSimpleTypeOrSimpleContent((Node)n);
                }
                HashSet set = Utils.getDerivedTypes((TypeEntry)typeEntry, (SymbolTable)this.m_definition.m_symTable);
            }
        }
    }

    private boolean handleChoices(Node node, Vector elementDecls) {
        int j;
        String m_method = "handleChoices";
        boolean bHasChoices = false;
        if (node == null || elementDecls == null || elementDecls.size() == 0) {
            return bHasChoices;
        }
        Vector choiceGroups = new Vector();
        Node choiceNode = null;
        NodeList children = node.getChildNodes();
        if (children != null && children.getLength() > 0) {
            for (int i = 0; i < children.getLength(); ++i) {
                QName subNodeKind = Utils.getNodeQName((Node)children.item(i));
                if (subNodeKind == null || !Constants.isSchemaXSD((String)subNodeKind.getNamespaceURI()) || !subNodeKind.getLocalPart().equals("choice")) continue;
                bHasChoices = true;
                choiceNode = children.item(i);
                if (choiceNode == null) continue;
                Vector<Object> choices = new Vector<Object>();
                choiceGroups.add(choices);
                NodeList kids = choiceNode.getChildNodes();
                if (kids == null || kids.getLength() <= 0) continue;
                WSElementDecl elementDecl = null;
                for (j = 0; j < kids.getLength(); ++j) {
                    Node kid = kids.item(j);
                    QName subNodeQName = Utils.getNodeQName((Node)kid);
                    String localPart = null;
                    Vector aGroup = null;
                    if (subNodeQName == null || !Constants.isSchemaXSD((String)subNodeQName.getNamespaceURI())) continue;
                    localPart = subNodeQName.getLocalPart();
                    if (localPart.equals("sequence") || localPart.equals("group")) {
                        aGroup = this.retriveAllElementsFromNode(kid, elementDecls);
                        if (aGroup == null || aGroup.size() <= 0) continue;
                        WSElementDecl[] groupArray = new WSElementDecl[aGroup.size()];
                        aGroup.toArray(groupArray);
                        aGroup.removeAllElements();
                        choices.add(groupArray);
                        continue;
                    }
                    if (!localPart.equals("element")) continue;
                    NamedNodeMap attribs = kid.getAttributes();
                    Node nameAttrib = attribs.getNamedItem("name");
                    String name = nameAttrib.getNodeValue().trim();
                    elementDecl = this.getElementDeclByName(name, elementDecls);
                    choices.add(elementDecl);
                }
            }
        }
        if (bHasChoices) {
            Object obj = null;
            WSElementDecl[] wsElementDeclArray = null;
            int index = -1;
            for (int i = 0; i < choiceGroups.size(); ++i) {
                Vector choices = null;
                obj = choiceGroups.get(i);
                if (obj == null || !(obj instanceof Vector)) continue;
                choices = obj;
                for (j = 0; j < choices.size(); ++j) {
                    obj = choices.get(j);
                    if (obj != null && obj instanceof WSElementDecl[]) {
                        wsElementDeclArray = obj;
                        for (int k = 0; k < wsElementDeclArray.length; ++k) {
                            if (wsElementDeclArray[k] == null || (index = elementDecls.indexOf(wsElementDeclArray[k])) < 0) continue;
                            if (!elementDecls.contains(choices)) {
                                elementDecls.insertElementAt(choices, index);
                            }
                            elementDecls.remove(wsElementDeclArray[k]);
                        }
                        continue;
                    }
                    if (obj == null || !(obj instanceof WSElementDecl) || (index = elementDecls.indexOf(obj)) < 0) continue;
                    if (!elementDecls.contains(choices)) {
                        elementDecls.insertElementAt(choices, index);
                    }
                    elementDecls.remove(obj);
                }
            }
        }
        return bHasChoices;
    }

    private Vector retriveAllElementsFromNode(Node node, Vector elementDecls) {
        WSElementDecl elementDecl = null;
        Vector<WSElementDecl> group = new Vector<WSElementDecl>();
        NodeList kids = node.getChildNodes();
        if (kids != null && kids.getLength() > 0) {
            for (int i = 0; i < kids.getLength(); ++i) {
                Node kid = kids.item(i);
                QName subNodeQName = Utils.getNodeQName((Node)kid);
                String localPart = null;
                Vector aGroup = null;
                if (subNodeQName == null || !Constants.isSchemaXSD((String)subNodeQName.getNamespaceURI())) continue;
                localPart = subNodeQName.getLocalPart();
                if (localPart.equals("sequence") || localPart.equals("group") || localPart.equals("choice")) {
                    aGroup = this.retriveAllElementsFromNode(kid, elementDecls);
                    if (aGroup == null || aGroup.size() <= 0) continue;
                    group.addAll(aGroup);
                    continue;
                }
                if (!localPart.equals("element")) continue;
                NamedNodeMap attribs = kid.getAttributes();
                Node nameAttrib = attribs.getNamedItem("name");
                String name = nameAttrib.getNodeValue().trim();
                elementDecl = this.getElementDeclByName(name, elementDecls);
                group.add(elementDecl);
            }
        }
        return group;
    }

    WSElementDecl getElementDeclByName(String name, Vector allElementDecls) {
        WSElementDecl elementDecl = null;
        if (name != null && allElementDecls != null) {
            String aName = null;
            Object obj = null;
            for (int i = 0; i < allElementDecls.size(); ++i) {
                obj = allElementDecls.get(i);
                if (obj == null || !(obj instanceof WSElementDecl) || (aName = ((WSElementDecl)obj).getQName().getLocalPart()) == null || !aName.endsWith(name)) continue;
                elementDecl = obj;
                break;
            }
        }
        return elementDecl;
    }

    public String getName() {
        if (this.m_type != null) {
            return this.m_type.getQName().getLocalPart();
        }
        return null;
    }

    public String getDisplayName() {
        String s = "";
        if (this.m_type != null) {
            s = s + org.apache.axis.wsdl.toJava.Utils.getXSIType((TypeEntry)this.m_type);
            if (this.isCollectionElement()) {
                s = s + "[]";
            }
            if (this.isBaseType()) {
                s = s + "(" + this.m_baseName + ")";
            }
        }
        return s;
    }

    public String getTypeLocalName() {
        String s = this.m_type.getQName().getLocalPart();
        if (s != null && s.lastIndexOf(">") != -1) {
            s = s.substring(s.lastIndexOf(">") + 1);
        }
        if (this.isCollectionElement()) {
            if (s.indexOf("[]") == 0) {
                s = s + "[]";
            } else {
                int idx = s.indexOf("[");
                if (idx > 0) {
                    s = s.substring(0, idx) + "[]";
                }
            }
        }
        return s;
    }

    public QName getQName() {
        if (this.m_type != null) {
            return this.m_type.getQName();
        }
        return null;
    }

    public String getBaseName() {
        if (this.m_type != null && this.m_type.getQName() != null) {
            return this.m_definition.getBaseName(this.m_type.getQName());
        }
        return null;
    }

    public Type getType() {
        return this.m_type;
    }

    public WSType getSimpleBaseType() {
        this.init();
        if (this.m_simpleBaseType != null && this.m_simpleBaseType.getSimpleBaseType() != null) {
            return this.m_simpleBaseType.getSimpleBaseType();
        }
        return this.m_simpleBaseType;
    }

    public boolean isCollectionType() {
        return this.m_type instanceof CollectionType;
    }

    public WSType getRefType() {
        this.init();
        if (this.m_references != null && this.m_references.length > 0) {
            for (int i = 0; i < this.m_references.length; ++i) {
                IWSTypeEntry typeEntry = this.m_references[i];
                if (typeEntry == null || !(typeEntry instanceof WSType)) continue;
                return (WSType)typeEntry;
            }
        }
        return null;
    }

    public WSElementDecl[] getElementDecls() {
        this.init();
        return this.m_elementDecls;
    }

    public Vector getElementDeclsWithChoicegroup() {
        this.init();
        return this.m_elementDeclWithChoiceGroups;
    }

    public WSAttribute[] getAttributes() {
        this.init();
        return this.m_attributes;
    }

    public String getEnumValuesString() {
        this.init();
        String s = null;
        if (this.m_enumBaseAndValues != null && this.m_enumBaseAndValues.size() > 1) {
            s = new String();
            for (int i = 1; i < this.m_enumBaseAndValues.size(); ++i) {
                if (i > 1) {
                    s = s + " or ";
                }
                s = s + this.m_enumBaseAndValues.get(i).toString();
            }
        }
        return s;
    }

    public boolean isEnumType() {
        this.init();
        return this.m_enumBaseAndValues != null && this.m_enumBaseAndValues.size() > 1;
    }

    public Vector getEnumValues() {
        this.init();
        return this.m_enumBaseAndValues;
    }

    public boolean isChoiceType() {
        this.init();
        return this.m_bChoice;
    }

    public Vector getEnumerationBaseAndValues(Node node, SymbolTable symbolTable) {
        int j;
        NodeList children;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName((Node)node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD((String)nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node simpleNode = null;
            for (j = 0; j < children.getLength() && simpleNode == null; ++j) {
                QName simpleKind = Utils.getNodeQName((Node)children.item(j));
                if (simpleKind == null || !simpleKind.getLocalPart().equals("simpleType") || !Constants.isSchemaXSD((String)simpleKind.getNamespaceURI())) continue;
                node = simpleNode = children.item(j);
            }
        }
        if ((nodeKind = Utils.getNodeQName((Node)node)) != null && nodeKind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD((String)nodeKind.getNamespaceURI())) {
            String javaName;
            QName baseType;
            children = node.getChildNodes();
            Node restrictionNode = null;
            for (j = 0; j < children.getLength() && restrictionNode == null; ++j) {
                QName restrictionKind = Utils.getNodeQName((Node)children.item(j));
                if (restrictionKind == null || !restrictionKind.getLocalPart().equals("restriction") || !Constants.isSchemaXSD((String)restrictionKind.getNamespaceURI())) continue;
                restrictionNode = children.item(j);
            }
            Type baseEType = null;
            if (restrictionNode != null && (baseEType = symbolTable.getType(baseType = Utils.getTypeQName(restrictionNode, (BooleanHolder)new BooleanHolder(), (boolean)false))) != null && (javaName = baseEType.getName()) != null && (javaName.equals("boolean") || !SchemaUtils.isSimpleSchemaType((QName)baseEType.getQName()))) {
                baseEType = null;
            }
            if (baseEType != null && restrictionNode != null) {
                Vector<String> v = new Vector<String>();
                NodeList enums = restrictionNode.getChildNodes();
                for (int i = 0; i < enums.getLength(); ++i) {
                    Node enumNode;
                    String value;
                    QName enumKind = Utils.getNodeQName((Node)enums.item(i));
                    if (enumKind == null || !enumKind.getLocalPart().equals("enumeration") || !Constants.isSchemaXSD((String)enumKind.getNamespaceURI()) || (value = Utils.getAttribute((Node)(enumNode = enums.item(i)), (String)"value")) == null) continue;
                    v.add(value);
                }
                if (v.isEmpty()) {
                    return null;
                }
                v.add(0, (String)baseEType);
                return v;
            }
        }
        return null;
    }

    private boolean isCollection() {
        if (this.m_type != null && this.m_type instanceof CollectionType) {
            return true;
        }
        return this.m_type.getDimensions() != null && this.m_type.getDimensions().compareTo("[]") == 0;
    }

    public boolean isCollectionElement() {
        return this.m_type != null && this.m_type instanceof CollectionType;
    }

    public boolean isCollectionParent(boolean bRPC) {
        if (bRPC) {
            return this.isRPCCollection();
        }
        return this.m_type != null && this.m_type.getDimensions() != null && this.m_type.getDimensions().compareTo("[]") == 0;
    }

    boolean isRPCCollection() {
        return this.m_type.getDimensions() != null && this.m_type.getDimensions().compareTo("[]") == 0;
    }

    public boolean isBaseType() {
        if (this.m_type != null) {
            return this.m_type.isBaseType();
        }
        return false;
    }

    public boolean isBlankType() {
        return !this.isBaseType() && !this.isChoiceType() && !this.isCollection() && !this.isCollectionElement() && !this.isCollectionType() && !this.isEnumType() && !this.isRPCCollection();
    }

    public String getMaxOccurs() {
        this.init();
        return this.m_maxOccurs;
    }

    public String getMinOccurs() {
        this.init();
        return this.m_minOccurs;
    }

    public String getNamespace() {
        if (this.m_type != null && this.m_type.getQName() != null) {
            return this.m_type.getQName().getNamespaceURI();
        }
        return null;
    }

    public String getNamespacePrefix() {
        String namespace = this.getNamespace();
        if (namespace != null && namespace.length() > 0 && this.m_definition != null) {
            return this.m_definition.getNamespacePrefix(namespace);
        }
        return null;
    }

    WSDefinition getDefinition() {
        return this.m_definition;
    }

    IWSTypeEntry[] getReferences() {
        return this.m_references;
    }

    QName getRestrictionBaseQName() {
        return this.m_restrictionBaseQName;
    }

    String getRestrictionBasePrefix() {
        if (this.m_restrictionBaseQName != null) {
            return this.getPrefix(this.m_restrictionBaseNode, this.m_restrictionBaseQName.getNamespaceURI());
        }
        return null;
    }

    String getPrefix(Node node, String namespace) {
        if (node == null || namespace == null || namespace.length() == 0) {
            return null;
        }
        NamedNodeMap attribs = node.getAttributes();
        if (attribs != null && attribs.getLength() > 0) {
            for (int i = 0; i < attribs.getLength(); ++i) {
                Node attrib = attribs.item(i);
                if (attrib.getNodeType() != 2 || !(attrib instanceof Attr)) continue;
                String value = ((Attr)attrib).getValue();
                String name = ((Attr)attrib).getName();
                if (name == null || !name.startsWith("xmlns:") || value == null || value.compareTo(namespace) != 0) continue;
                return name.substring(6);
            }
        }
        return this.getPrefix(node.getParentNode(), namespace);
    }
}

